package gov.va.med.mhv.usermgmt.data.repository;

import java.util.List;

import gov.va.med.mhv.usermgmt.data.model.HealthCareProvider;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface HealthCareProviderRepository extends JpaRepository<HealthCareProvider, Long> {
	/**
	 * 
	 * @param userName
	 * @return
	 */
	@Query("select h from HealthCareProvider h where h.userProfileId = :userProfileId")
	public List<HealthCareProvider> findByUserProfileId(@Param("userProfileId") Long userProfileId);
		
	@Query("select h from HealthCareProvider h where h.healthCareProviderId = :healthCareProviderId")
	public HealthCareProvider findByHealthCareProviderId(@Param("healthCareProviderId") Long healthCareProviderId);
	
	@Query("select h from HealthCareProvider h where h.userProfileId = :userProfileId and h.providerType = 'P'")
	public List<HealthCareProvider> findPrimaryProvider(@Param("userProfileId") Long userProfileId);
	
}